﻿var tables = {
    context: $(".v-lookupTables"),
    datatable: null,
    changeCategoryItems: null,
    refreshDataTable: function () {
        tables.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-tablesTable").a4datatable({
            height: "full",
            stateKey: "LookupTables",
            ajaxAction: a4.getAction("GetLookupTables", "Surveys", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": true, "Class": "id", "Key": true },
                { "Name": "Name", "Title": resources.LookUpTableName, "Data": "Name", "Class": "v-name" },
                { "Name": "RowCount", "Title": resources.RowCount, "Data": "RowCount" },
                { "Name": "CreationDate", "Title": resources.CreationDate, "Data": "CreationDate" },
                { "Name": "CreatedByName", "Title": resources.CreatedBy, "Data": "CreatedByName" },
                { "Name": "ModificationDate", "Title": resources.LastModificationDate, "Data": "ModificationDate" },
                { "Name": "ModifiedByName", "Title": resources.LastModifiedBy, "Data": "ModifiedByName" }
            ],
            localizableTexts: { "Search": resources.SearchSurveysLookupTables },
            defaultSorting: "Name",
            toolBarItems: tables.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                if (action == "delete") {
                    tables.deleteItems(ids);
                }
            },
            contextMenuItems: tables.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        modalDialog.showWindow(a4.getAction("EditLookupTable", "Surveys", "Settings", { id: row.Id, name: row.Name }), 450, 650, { afterClose: function () { tables.refreshDataTable(); } });
                        break;
                    case "export":
                        a4.showBusyBox();

                        a4.callServerMethod(a4.getAction("ExportLookupTable", "Surveys", "Settings"), { name: row.Name },
                            function (result) {
                                a4.hideBusyBox();
                                window.location = a4.getAction("GetLookupTableFile", "Surveys", "Settings", { GetFile: result });
                            }, function (error) {
                                a4.onAjaxPageMethodError(error);
                            });
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getAction("LookupTableProperties", "Surveys", "Settings", { id: row.Id }), 250, 600, { afterClose: function () { tables.refreshDataTable(); } });
                        break;
                    case "delete":
                        tables.deleteItems(row.Id);
                        break;
                    case "duplicate":
                        modalDialog.showWindow(a4.getAction("CopyLookupTable", "Surveys", "Settings", { id: row.Id, name: row.Name }), 250, 650, { afterClose: function () { tables.refreshDataTable(); } });
                        break;
                    case "edittable":
                        window.location = a4.getAction("LookupTableName", "Surveys", "Settings", { id: row.Id });
                        break;
                }
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addTable", function () {
            modalDialog.showWindow(a4.getAction("ImportLookupTable", "Surveys", "Settings"), 450, 650, { afterClose: function () { tables.refreshDataTable(); } });
        });
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        a4.callServerMethod(a4.getAction("GetSurveyReferences", "Surveys", "Settings"), { tableIds: items },
            function (result) {
                var height = 250;
                var deleteContainer = $("#deleteTableContainer").clone();
                var useResources = confirmDeleteResources;

                if (_.size(result.data) > 0) {
                    var ul = $("ul", deleteContainer);

                    // Add surveys
                    $.each(result.data, function (i, val) {
                        ul.append("<li>" + val + "</li>");
                        height += 50;
                    });

                    messageContent = deleteContainer.html();
                    useResources = modalDialog.createDialogResources(messageContent, confirmDeleteResources.Title, confirmDeleteResources.CheckBoxText, confirmDeleteResources.ConfirmButton);
                }

                modalDialog.showConfirmDialog(useResources, function () {
                    a4.callServerMethod(a4.getAction("DeleteLookupTables", "Surveys", "Settings"), { ids: items }, function (result) {
                        tables.refreshDataTable();
                    });
                }, height, 550, true, { "count": itemsCount });
            },
            function () { }
        );
    },
    getContextMenuItems: function () {
        var items = [];

        if (canModifySettings) {
            if (isLookupTableFeatureEnabled) {
                items.push({ "Action": "edittable", "Label": resources.Edit });
            }            
            items.push({ "Action": "delete", "Label": resources.Delete });
            items.push({ "Action": "properties", "Label": resources.Properties });
            items.push({ "Divider": true });
            items.push({ "Action": "edit", "Label": resources.Import });
            items.push({ "Action": "export", "Label": resources.Export });
            items.push({ "Action": "duplicate", "Label": resources.Duplicate });
        }

        return items;
    },
    getToolBarItems: function () {
        var items = [];

        if (canModifySettings) {
            items.push({ "Action": "delete", "Label": resources.Delete });
        }

        return items;
    }
}

$(document).ready(function () {
    if (tables.context.length > 0) {
        tables.initializeDataTable();
        tables.bindEvents();
    }
});